import { Link } from "wouter";

export function Footer() {
  return (
    <footer className="bg-slate-800 dark:bg-slate-900 text-white mt-20" data-testid="footer">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-10 mb-8">
          <div>
            <h3 className="text-blue-400 text-2xl font-bold mb-3" data-testid="text-footer-logo">My Gift Info</h3>
            <p className="text-slate-400 text-sm leading-relaxed">
              Your trusted platform for checking gift card balances and managing your cards safely and securely.
            </p>
          </div>
          <div>
            <h4 className="text-white font-semibold text-lg mb-4">Quick Links</h4>
            <div className="flex flex-col gap-2">
              <Link href="/" className="text-slate-400 hover:text-blue-400 text-sm transition-colors" data-testid="link-footer-home">
                Home
              </Link>
              <Link href="/privacy-policy" className="text-slate-400 hover:text-blue-400 text-sm transition-colors" data-testid="link-footer-privacy">
                Privacy Policy
              </Link>
              <Link href="/terms-of-service" className="text-slate-400 hover:text-blue-400 text-sm transition-colors" data-testid="link-footer-terms">
                Terms of Service
              </Link>
            </div>
          </div>
          <div>
            <h4 className="text-white font-semibold text-lg mb-4">Contact</h4>
            <div className="flex flex-col gap-2">
              <p className="text-slate-400 text-sm">Email: support@mygiftinfo.com</p>
              <p className="text-slate-400 text-sm">Hours: Mon-Fri, 9AM-5PM EST</p>
            </div>
          </div>
        </div>
        <div className="border-t border-slate-700 pt-6 text-center">
          <p className="text-slate-400 text-sm" data-testid="text-copyright">
            &copy; {new Date().getFullYear()} My Gift Info. All rights reserved.
          </p>
        </div>
      </div>
    </footer>
  );
}
