import { useRef } from "react";
import { Header } from "@/components/layout/header";
import { Footer } from "@/components/layout/footer";
import { CardForm } from "@/components/card-form";
import { BenefitsSection } from "@/components/benefits-section";
import { HowItWorksSection } from "@/components/how-it-works-section";
import { FeaturesSection } from "@/components/features-section";
import { CTASection } from "@/components/cta-section";

export default function Home() {
  const formRef = useRef<HTMLDivElement>(null);

  const scrollToForm = () => {
    formRef.current?.scrollIntoView({ behavior: "smooth" });
  };

  return (
    <div className="min-h-screen flex flex-col" data-testid="page-home">
      <Header />
      
      <main className="flex-1">
        <div className="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
          <div className="text-center mb-10" ref={formRef}>
            <h1 className="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-foreground mb-4 leading-tight" data-testid="text-hero-title">
              Bonus & Discount Reference Lookup
            </h1>
            <p className="text-muted-foreground text-base sm:text-lg max-w-2xl mx-auto leading-relaxed" data-testid="text-hero-description">
              Enter your reference information below to review internal bonus and discount codes provided by our company. This tool is for educational and informational purposes only.
            </p>
          </div>

          <CardForm />
        </div>

        <div className="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
          <BenefitsSection />
          <HowItWorksSection />
          <FeaturesSection />
          <CTASection onCheckBalance={scrollToForm} />
        </div>
      </main>

      <Footer />
    </div>
  );
}
