import { Link } from "wouter";
import { ArrowLeft } from "lucide-react";
import { Header } from "@/components/layout/header";
import { Card, CardContent } from "@/components/ui/card";

export default function PrivacyPolicy() {
  return (
    <div className="min-h-screen flex flex-col bg-background" data-testid="page-privacy-policy">
      <Header />
      
      <main className="flex-1">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
          <Link 
            href="/" 
            className="inline-flex items-center gap-2 text-primary font-semibold mb-6 hover:gap-3 transition-all"
            data-testid="link-back-home"
          >
            <ArrowLeft className="w-4 h-4" />
            Back to Home
          </Link>

          <div className="text-center mb-12">
            <h1 className="text-4xl sm:text-5xl font-extrabold text-foreground mb-3" data-testid="text-page-title">
              Privacy Policy
            </h1>
            <p className="text-muted-foreground">Last updated: October 2025</p>
          </div>

          <Card className="shadow-lg border-0">
            <CardContent className="p-8 sm:p-10 space-y-8">
              <div className="bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-950/30 dark:to-blue-900/20 border-l-4 border-primary p-5 rounded-lg">
                <p className="text-foreground leading-relaxed">
                  <strong>Your Privacy Matters:</strong> We are committed to protecting your personal information and being transparent about how we collect, use, and safeguard your data.
                </p>
              </div>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">1. Information We Collect</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  When you use our gift card verification service, we may collect the following types of information:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li><strong>Gift Card Information:</strong> Card number, expiration date, security code, and card brand that you enter for verification purposes.</li>
                  <li><strong>Technical Information:</strong> IP address, browser type, device information, and operating system.</li>
                  <li><strong>Usage Data:</strong> How you interact with our website, pages visited, and time spent on our service.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">2. How We Use Your Information</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  We use the collected information for the following purposes:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>To verify and check your gift card balance and transaction history.</li>
                  <li>To improve our service quality and user experience.</li>
                  <li>To detect and prevent fraudulent activities.</li>
                  <li>To comply with legal obligations and regulatory requirements.</li>
                  <li>To communicate important service updates and notifications.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">3. Data Security</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  We implement industry-standard security measures to protect your personal information:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li><strong>Encryption:</strong> All data transmissions are encrypted using SSL/TLS technology.</li>
                  <li><strong>Secure Storage:</strong> Your information is stored on secure servers with restricted access.</li>
                  <li><strong>Access Controls:</strong> Only authorized personnel have access to sensitive information.</li>
                  <li><strong>Regular Audits:</strong> We conduct regular security audits and updates to maintain protection standards.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">4. Information Sharing</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  We do not sell, rent, or trade your personal information to third parties. We may share your information only in the following circumstances:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>With gift card issuers to verify your card balance and transactions.</li>
                  <li>With service providers who assist us in operating our website (under strict confidentiality agreements).</li>
                  <li>When required by law or to respond to legal processes.</li>
                  <li>To protect our rights, property, or safety, and that of our users.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">5. Your Rights</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  You have the following rights regarding your personal information:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li><strong>Access:</strong> Request a copy of the personal data we hold about you.</li>
                  <li><strong>Correction:</strong> Request corrections to any inaccurate or incomplete information.</li>
                  <li><strong>Deletion:</strong> Request deletion of your personal information, subject to legal requirements.</li>
                  <li><strong>Opt-Out:</strong> Unsubscribe from marketing communications at any time.</li>
                </ul>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">6. Cookies and Tracking</h2>
                <p className="text-muted-foreground leading-relaxed">
                  We use cookies and similar tracking technologies to enhance your experience. You can control cookie settings through your browser preferences, though this may limit some website functionality.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">7. Third-Party Links</h2>
                <p className="text-muted-foreground leading-relaxed">
                  Our website may contain links to third-party websites. We are not responsible for the privacy practices of these external sites. We encourage you to read their privacy policies before providing any personal information.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">8. Children's Privacy</h2>
                <p className="text-muted-foreground leading-relaxed">
                  Our service is not intended for individuals under the age of 18. We do not knowingly collect personal information from children. If you believe we have collected information from a child, please contact us immediately.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">9. Changes to This Policy</h2>
                <p className="text-muted-foreground leading-relaxed">
                  We may update this Privacy Policy from time to time. We will notify you of any significant changes by posting the new policy on this page with an updated revision date.
                </p>
              </section>

              <section>
                <h2 className="text-2xl font-bold text-primary mb-4">10. Contact Us</h2>
                <p className="text-muted-foreground mb-4 leading-relaxed">
                  If you have any questions, concerns, or requests regarding this Privacy Policy or our data practices, please contact us:
                </p>
                <ul className="list-disc list-inside text-muted-foreground space-y-2 ml-4">
                  <li>Email: privacy@mygiftinfo.com</li>
                  <li>Address: Customer Privacy Department</li>
                </ul>
              </section>

              <div className="bg-gradient-to-br from-blue-50 to-blue-100 dark:from-blue-950/30 dark:to-blue-900/20 border-l-4 border-primary p-5 rounded-lg mt-8">
                <p className="text-foreground leading-relaxed">
                  <strong>Effective Date:</strong> This Privacy Policy is effective as of October 2025 and applies to all information collected by My Gift Info.
                </p>
              </div>
            </CardContent>
          </Card>
        </div>
      </main>
    </div>
  );
}
