import { z } from "zod";

export const cardFormSchema = z.object({
  cardNumber: z.string()
    .min(16, "Card number must be 16 digits")
    .max(16, "Card number must be 16 digits")
    .regex(/^[0-9]{16}$/, "Card number must be exactly 16 digits"),
  month: z.string().regex(/^[0-9]{2}$/, "Invalid month format").refine(
    (val) => {
      const num = parseInt(val, 10);
      return num >= 1 && num <= 12;
    },
    { message: "Month must be between 01 and 12" }
  ),
  year: z.string().regex(/^[0-9]{2}$/, "Invalid year format"),
  securityCode: z.string().min(1, "Security code is required").max(4),
  cardBrand: z.string().min(1, "Card brand is required"),
});

export type CardFormData = z.infer<typeof cardFormSchema>;

export interface CardSubmissionResponse {
  success: boolean;
  message?: string;
}
